/*
CREATED BY: Jonathan Sebastiani
CREATED DATE: 10/17/2025
DESCRIPTION: Define the top employees with the highest total amout of sales
NOTES: Combine 3 different databases to form a relational evaluation of individual sales involving invoice, customer, and employee.
	Group by employee
*/

SELECT
	e.EmployeeId AS 'Employee ID',
	e.FirstName || ' ' || e.LastName AS 'Sales Rep / Employee Full Name',
	SUM(i.total) AS 'Total Sales Amount'
FROM	
	Invoice AS i
LEFT OUTER JOIN
	Customer AS c
ON
	i.CustomerId = c.CustomerId
LEFT OUTER JOIN
	Employee AS e
ON
	c.SupportRepId = e.EmployeeId 
GROUP BY
	e.EmployeeId
	
/*
RESULTS:
	We find that there are only 3 employees who have actually been making any sales at all. 
	Of which, Jane Peacock has the most sales with a total amount of $1,833.90
*/


