/*
CREATED BY: Jonathan Sebastiani
CREATED DATE: 10/17/2025
DESCRIPTION: Define the top 10 individual sales made by an employee
NOTES: Combine 3 different databases to form a relational evaluation of individual sales involving invoice, customer, and employee.
*/

SELECT
	i.CustomerId AS 'Customer ID',
	c.FirstName || ' ' || c.LastName AS 'Customer Full Name',
	e.EmployeeId AS 'Employee ID',
	e.FirstName || ' ' || e.LastName AS 'Sales Rep / Employee Full Name',
	i.InvoiceId AS 'Invoice ID',
	strftime("%Y-%m-%d", i.InvoiceDate) AS 'Date; no time',
	i.total AS 'Individual Sale Amount'
FROM	
	Invoice AS i
LEFT OUTER JOIN
	Customer AS c
ON
	i.CustomerId = c.CustomerId
LEFT OUTER JOIN
	Employee AS e
ON
	c.SupportRepId = e.EmployeeId 
ORDER BY
	total DESC
LIMIT 10